% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvsit-class.R
\docType{class}
\name{cvsit-class}
\alias{cvsit-class}
\alias{cvsit}
\alias{show,cvsit-method}
\alias{summary,cvsit-method}
\alias{plot,cvsit,missing-method}
\alias{cvsit-method}
\title{The cvsit Class.}
\usage{
\S4method{show}{cvsit}(object)

\S4method{summary}{cvsit}(object)

\S4method{plot}{cvsit,missing}(x, y, type = 1, ...)
}
\arguments{
\item{object}{A cvsit class object}

\item{x}{A cvsit class object}

\item{y}{missing}

\item{type}{Plot type. 1 distribution of the HR under test For the Top K taxa using PCA. 2 distribution of the HR under test For the Top K taxa using PLS.}

\item{...}{The usual extra arguments to generic functions — see \code{\link[graphics]{plot}}, \code{\link[graphics]{plot.default}}}
}
\description{
Class of object returned by function \code{\link[MicrobiomeSurv]{cvsit}}.
}
\section{Slots}{

\describe{
\item{\code{HRpca}}{A 3-way array in which first, second, and third dimensions correspond to number of taxa, Hazard ratio information (Estimated HR, LowerCI and UpperCI), and number of cross validation respectively. This contains the estimated HR on test data and dimension reduction method is PCA.}

\item{\code{HRpls}}{A 3-way array in which first, second, and third dimensions correspond to number of taxa, Hazard ratio information (Estimated HR, LowerCI and UpperCI), and number of cross validation respectively. This contains the estimated HR on test data and dimension reduction method is PLS.}

\item{\code{Ntaxa}}{The number of taxa in the reduced matrix.}

\item{\code{Ncv}}{The number of cross validation done.}

\item{\code{Top}}{A sequence of top k taxa considered. Default is Top=seq(5,100,by=5).}
}}

\seealso{
\code{\link[MicrobiomeSurv]{CVPcaPls}}, \code{\link[MicrobiomeSurv]{SurvPcaClass}}, \code{\link[MicrobiomeSurv]{SurvPlsClass}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
