% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvle-class.R
\docType{class}
\name{cvle-class}
\alias{cvle-class}
\alias{cvle}
\alias{show,cvle-method}
\alias{summary,cvle-method}
\alias{plot,cvle,missing-method}
\alias{cvle-method}
\title{The cvle Class.}
\usage{
\S4method{show}{cvle}(object)

\S4method{summary}{cvle}(object)

\S4method{plot}{cvle,missing}(x, y, type = 1, ...)
}
\arguments{
\item{object}{A cvle class object}

\item{x}{A cvle class object}

\item{y}{missing}

\item{type}{Plot type. 1 distribution of the HR under training and test set. 2 HR vs number selected taxa.}

\item{...}{The usual extra arguments to generic functions — see \code{\link[graphics]{plot}}, \code{\link[graphics]{plot.default}}}
}
\description{
Class of object returned by function \code{\link[MicrobiomeSurv]{CVLasoelascox}}.
}
\section{Slots}{

\describe{
\item{\code{Coef.mat}}{A matrix of coefficients with rows equals to number of cross validations and columns equals to number of taxa,}

\item{\code{lambda}}{A vector of estimated optimum lambda for each iterations.}

\item{\code{n}}{A vector of the number of selected taxa.}

\item{\code{mi.mat}}{A matrix with 0 and 1. Number of rows equals to number of iterations and number of columns equals to number of taxa. 1 indicates that the particular taxon was selected or had nonzero coefficient and otherwise it is zero.}

\item{\code{HRTrain}}{A matrix of survival information for the training dataset. It has three columns representing the estimated HR, the 95\% lower confidence interval and the 95\% upper confidence interval.}

\item{\code{HRTest}}{A matrix of survival information for the test dataset. It has three columns representing the estimated HR, the 95\% lower confidence interval and the 95\% upper confidence interval.}

\item{\code{pld}}{A vector of partial likelihood deviance at each cross validations.}

\item{\code{Micro.mat}}{The microbiome matrix that was used for the analysis which can either be the full the full data or a reduced supervised PCA version.}
}}

\seealso{
\code{\link[MicrobiomeSurv]{EstimateHR}}, \code{\link[glmnet]{glmnet}}, \code{\link[MicrobiomeSurv]{Lasoelascox}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
