% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SITaxa.R
\name{SITaxa}
\alias{SITaxa}
\title{Sequential Increase in Taxa for the PCA or PLS classifier}
\usage{
SITaxa(
  TopK = 15,
  Survival,
  Micro.mat,
  Censor,
  Reduce = TRUE,
  Select = 5,
  Prognostic = NULL,
  Plot = FALSE,
  DM = c("PLS", "PCA"),
  ...
)
}
\arguments{
\item{TopK}{Top K taxa (5 by default) to be used in the sequential analysis.}

\item{Survival}{A vector of survival time with length equals to number of subjects.}

\item{Micro.mat}{A large or small microbiome profile matrix. A matrix with microbiome profiles where the number of rows should be equal to the number of taxa and number of columns should be equal to number of patients.}

\item{Censor}{A vector of censoring indicator.}

\item{Reduce}{A boolean parameter indicating if the microbiome profile matrix should be reduced, default is TRUE and larger microbiome profile matrix is reduced by supervised pca approach and first pca is extracted from the reduced matrix to be used in the classifier.}

\item{Select}{Number of taxa to be selected from supervised PCA. This is valid only if the argument Reduce=TRUE.}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Plot}{A boolean parameter indicating if Plot should be shown. Default is FALSE.}

\item{DM}{Dimension reduction method which can either be PLS or PCA.}

\item{...}{Additinal arguments for plotting and only valid  if Plot=TRUE}
}
\value{
A list containing a data frame with estimated HR along with 95\% CI at each TopK value for the sequential analysis.
  \item{Result}{The hazard ratio statistics (HR, Lower confidence interval and upper confidence interval) of the lower riskgroup based for each sequential metabolite analysis}
  \item{TopKplot}{A graphical representation of the Result containing the hazard ratio statistics}
}
\description{
The Function fits cox proportional hazard model and does classification by sequentially increasing the taxa
using either PCA or PLS based on the topK taxa specified.
}
\details{
This function sequentially increase the number of top K taxa to be used in the PCA or PLS methods in order to obtain the risk score.
This function internally calls \code{\link[MicrobiomeSurv]{MSpecificCoxPh}} to rank the taxa based on HR for each taxon.
Therefore taxa can be ordered based on increasing order of the HR for low risk group.
Thereafter, the function takes few top K (5 is the default) to be used in the sequential analysis.
}
\examples{
# Prepare data
data(Week3_response)
Week3_response = data.frame(Week3_response)
surv_fam_shan_w3 = data.frame(cbind(as.numeric(Week3_response$T1Dweek),
as.numeric(Week3_response$T1D)))
colnames(surv_fam_shan_w3) = c("Survival", "Censor")
prog_fam_shan_w3 = data.frame(factor(Week3_response$Treatment_new))
colnames(prog_fam_shan_w3) = c("Treatment")
data(fam_shan_trim_w3)
names_fam_shan_trim_w3 =
c("Unknown", "Lachnospiraceae", "S24.7", "Lactobacillaceae", "Enterobacteriaceae", "Rikenellaceae")
fam_shan_trim_w3 = data.matrix(fam_shan_trim_w3[ ,2:82])
rownames(fam_shan_trim_w3) = names_fam_shan_trim_w3
# Using the function
SITaxa_fam_shan_w3 = SITaxa(TopK=5,
                            Survival = surv_fam_shan_w3$Survival,
                            Micro.mat = fam_shan_trim_w3,
                            Censor = surv_fam_shan_w3$Censor,
                            Reduce=TRUE,
                            Select=5,
                            Prognostic=prog_fam_shan_w3,
                            Plot = TRUE,
                            DM="PLS")

# For the HR statistics
SITaxa_fam_shan_w3$Result

# For the graphical output
SITaxa_fam_shan_w3$TopKplot
}
\seealso{
\code{\link[survival]{coxph}},  \code{\link[MicrobiomeSurv]{EstimateHR}}, \code{\link[MicrobiomeSurv]{MSpecificCoxPh}}, \code{\link[MicrobiomeSurv]{SurvPcaClass}}, \code{\link[MicrobiomeSurv]{SurvPlsClass}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
