% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantileAnalysis.R
\name{QuantileAnalysis}
\alias{QuantileAnalysis}
\title{Quantile sensitivity analysis}
\usage{
QuantileAnalysis(
  Survival,
  Micro.mat,
  Censor,
  Reduce = TRUE,
  Select = 5,
  Prognostic = NULL,
  Plots = FALSE,
  DM = c("PLS", "PCA", "SM"),
  Alpha = 1
)
}
\arguments{
\item{Survival}{A vector of survival time with length equals to number of subjects.}

\item{Micro.mat}{A large or small microbiome profile matrix. A matrix with microbiome profiles where the number of rows should be equal to the number of taxa and number of columns should be equal to number of patients.}

\item{Censor}{A vector of censoring indicator.}

\item{Reduce}{A boolean parameter indicating if the microbiome profile matrix should be reduced, default is TRUE and larger microbiome profile matrix is reduced by supervised pca approach and first pca is extracted from the reduced matrix to be used in the classifier.}

\item{Select}{Number of taxa (default is 5) to be selected from supervised PCA. This is valid only if the argument Reduce=TRUE.}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Plots}{A boolean parameter indicating if the graphical represenataion of the analysis should be shown. Default is FALSE and it is only valid for the PCA or PLS dimension method.}

\item{DM}{The dimension method to be used. PCA implies using the \code{\link[MicrobiomeSurv]{SurvPcaClass}}, PLS uses \code{\link[MicrobiomeSurv]{SurvPcaClass}} while SM uses the \code{\link[MicrobiomeSurv]{Lasoelascox}} which ruses the shrinkage method techniques such as lasso and elastic net.}

\item{Alpha}{The mixing parameter for glmnet (see \code{\link[glmnet]{glmnet}}). The range is 0<= Alpha <= 1. The Default is 1.}
}
\value{
A Dataframe is returned depending on weather a data reduction method should be used or not. The dataframe contains the HR of the low risk group for each percentile.
}
\description{
The function performs sensitivity of the cut off quantile for obtaining the risk group obtained
under \code{\link[MicrobiomeSurv]{SurvPlsClass}}, \code{\link[MicrobiomeSurv]{SurvPcaClass}}
or \code{\link[MicrobiomeSurv]{Lasoelascox}} requires for the survival analysis and classification.
}
\details{
This function investigates how each analysis differs from the general median cutoff of 0.5,
therefore to see the sensitive nature of the survival result different quantiles ranging from 10th percentile to 90th percentiles were used.
The sensitive nature of the quantile is investigated under \code{\link[MicrobiomeSurv]{SurvPlsClass}}, \code{\link[MicrobiomeSurv]{SurvPcaClass}}
or \code{\link[MicrobiomeSurv]{Lasoelascox}} while relate to the 3 different Dimension method to select from.
}
\examples{
# Prepare data
data(Week3_response)
Week3_response = data.frame(Week3_response)
surv_fam_shan_w3 = data.frame(cbind(as.numeric(Week3_response$T1Dweek),
as.numeric(Week3_response$T1D)))
colnames(surv_fam_shan_w3) = c("Survival", "Censor")
prog_fam_shan_w3 = data.frame(factor(Week3_response$Treatment_new))
colnames(prog_fam_shan_w3) = c("Treatment")
data(fam_shan_trim_w3)
names_fam_shan_trim_w3 =
c("Unknown", "Lachnospiraceae", "S24.7", "Lactobacillaceae", "Enterobacteriaceae", "Rikenellaceae")
fam_shan_trim_w3 = data.matrix(fam_shan_trim_w3[ ,2:82])
rownames(fam_shan_trim_w3) = names_fam_shan_trim_w3
# Using the PCA method
QuantileAnalysis_PCA_fam_shan_w3 = QuantileAnalysis(Survival = surv_fam_shan_w3$Survival,
                                                    Micro.mat = fam_shan_trim_w3,
                                                    Censor = surv_fam_shan_w3$Censor,
                                                    Reduce=TRUE,
                                                    Select= 5,
                                                    Prognostic=prog_fam_shan_w3,
                                                    Plots = TRUE,
                                                    DM="PCA",
                                                    Alpha =1)

}
\seealso{
\code{\link[survival]{coxph}},\code{\link[MicrobiomeSurv]{EstimateHR}},
\code{\link[MicrobiomeSurv]{SurvPcaClass}},
 \code{\link[MicrobiomeSurv]{SurvPlsClass}},\code{\link[MicrobiomeSurv]{Lasoelascox}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
