% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getFormula}
\alias{getFormula}
\title{Formula getter}
\usage{
getFormula(model)
}
\arguments{
\item{model}{the model name.}
}
\value{
the function corresponding to the formula of the model.
}
\description{
Returns the formula associated with the specified model.
}
\examples{
f <- getFormula("gompertz")
# We need to set the parameters (N0, ..., lambda)
f2 <- f(0.1, 2, 0.2, 5)
# And we can then use the function "f(x)" with x the time
f2(4)
## [1] 0.1150952

# The same, more direct
F <- getFormula("gompertz")(0.1, 2, 0.2, 5)
F(4)
## [1] 0.1150952
}
