% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\name{.MicrobialGrowth.gompertz}
\alias{.MicrobialGrowth.gompertz}
\title{Gompertz regression function}
\usage{
.MicrobialGrowth.gompertz(
  x,
  y,
  clip = c(-Inf, Inf),
  start = list(),
  lower = list(),
  upper = list(),
  nls.args = list(),
  callbackError = NULL
)
}
\arguments{
\item{x}{index series or time series.}

\item{y}{values or list of values to regress (should not be logged).}

\item{clip}{a pair of values indicating in which interval to clip the data \code{y}. When \code{clip} is missing, default values are used.}

\item{start}{a named list of starting estimates. When \code{start} is missing, default values are used.}

\item{lower}{a named list of lower bounds. When \code{lower} is missing, default values are used.}

\item{upper}{a named list of upper bounds. When \code{upper} is missing, default values are used.}

\item{nls.args}{additional parameters to use when calling \link[stats]{nls}.}

\item{callbackError}{function to call on error during regression.}
}
\value{
a MicrobialGrowth-object composed of
\item{call}{the matched call with several components.}
\item{coefficients}{coefficients obtained by regression.}
\item{data}{data used for regression, once the y values are clipped}
\item{f}{a list of functions such as \code{formula} to retrieve the function of the model with the coefficients obtained by regression, \code{confint} to retrieve the confidence intervals, etc.}
\item{isValid}{a boolean indicating whether the regression was successful or not.}
\item{message}{contains the error message if the regression fails, \code{NULL} otherwise.}
\item{reg}{the \code{nls} object returned by the \code{nls} function.}
}
\description{
Regression function for Gompertz's model
}
\details{
The default values for \code{clip}, \code{start}, \code{lower} and \code{upper} are calculated based on the given data. These default values can be known through the \code{call} member of the returned value.

The \code{nls.args} argument is a list that can contain any \link[stats]{nls} function argument except \code{formula}, \code{algorithm}, \code{start}, \code{lower} and \code{upper} which are already fixed (via a homonymous or hard-coded argument).

For the \code{callbackError} argument, prefer the \code{stop} function to block or \code{warning} to not be blocking.
}
\seealso{
\link{MicrobialGrowth}, \link{.gompertz.formula}
}
