% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{ttest_scores}
\alias{ttest_scores}
\title{ttest_scores}
\usage{
ttest_scores(dat, pred, pheno)
}
\arguments{
\item{dat}{The data.frame containing the 2 variables}

\item{pred}{character indicating the y variable}

\item{pheno}{character indicating the binary variable}
}
\value{
plotly boxplot with the continuous variable split using the binary variable
}
\description{
#' Function that creates a boxplot with a continuous variable split using the binary variable
}
\examples{
library(MiMIR)
library(plotly)

#load the dataset
metabolic_measures <- synthetic_metabolic_dataset
phenotypes <- synthetic_phenotypic_dataset

#Compute the mortality score
mortScore<-comp.mort_score(metabolic_measures,quiet=TRUE)
dat<-data.frame(predictor=mortScore, pheno=phenotypes$sex)
colnames(dat)<-c("predictor","pheno")
ttest_scores(dat = dat, pred= "mortScore", pheno="sex")

}
