% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{roc_surro}
\alias{roc_surro}
\title{roc_surro}
\usage{
roc_surro(surrogates, bin_phenotypes, x_name)
}
\arguments{
\item{surrogates}{numeric data.frame of metabolomics-based surrogate values by Bizzarri et al.}

\item{bin_phenotypes}{logic data.frame of binarized phenotypes}

\item{x_name}{vector of strings with the names of the selected binary phenotypes for the roc}
}
\value{
plotly image with the ROC curves for one or more selected variables
}
\description{
Function that creates a ROC curve of the selected metabolic surrogates as a plotly image
}
\examples{
require(pROC)
require(plotly)
require(foreach)
require(MiMIR)

#load the dataset
met <- synthetic_metabolic_dataset
phen<- synthetic_phenotypic_dataset

#Calculating the binarized surrogates
b_phen<-binarize_all_pheno(phen)
#Apply a surrogate models and plot the ROC curve
surr<-calculate_surrogate_scores(met, phen, MiMIR::PARAM_surrogates, colnames(b_phen))
#Plot the ROC curves
roc_surro(surr$surrogates, b_phen, "sex")

}
