% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MexBrewer-package.R
\name{ggplot2-scales-discrete}
\alias{ggplot2-scales-discrete}
\alias{scale_color_mex_d}
\alias{scale_colour_mex_d}
\alias{scale_fill_mex_d}
\title{Discrete MexBrewer scales for use with ggplot2}
\usage{
scale_color_mex_d(palette_name, direction = 1, override.order = FALSE, ...)

scale_colour_mex_d(palette_name, direction = 1, override.order = FALSE, ...)

scale_fill_mex_d(palette_name, direction = 1, override.order = FALSE, ...)
}
\arguments{
\item{palette_name}{Name of Palette. Choices are:
\code{Alacena}, \code{Atentado}, \code{Aurora}, \code{Casita1}, \code{Casita2}, \code{Casita3}, \code{Concha}, \code{Frida}, \code{Huida},  \code{Maiz},  \code{Naturaleza},\code{Ofrenda},
\code{Revolucion}, \code{Ronda}, \code{Taurus1}, \code{Taurus2},\code{Tierra}, \code{Vendedora}.}

\item{direction}{Sets order of colors. Default palette is 1. If direction is -1, palette color order is reversed}

\item{override.order}{Colors are picked from palette to maximize readability and aesthetics. This means
that colors are not always selected in sequential order from the full palette. If override.order is set to TRUE,
colors are selected in sequential order from the full palette instead. Default is FALSE.}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{discrete_scale}}}
}
\value{
A \code{ScaleDiscrete} object that can be added to a \code{ggplot} object
}
\description{
Functions \code{\link{scale_color_mex_d}} and \code{\link{scale_fill_mex_d}} enable the use of \code{MexBrewer} colors with \code{ggplot2} discrete scales.
}
\examples{
library(ggplot2)
ggplot(data=iris, aes(x=Species, y=Sepal.Length, fill=Species)) +
geom_violin() +
scale_fill_mex_d("Aurora")
}
\seealso{
Other color scales: 
\code{\link{ggplot2-scales-continuous}}
}
\concept{color scales}
