% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peaks_func.r
\name{peaks}
\alias{peaks}
\title{Peak searching algorithm without retention times}
\usage{
peaks(
  data,
  begin_search = NULL,
  end_search = NULL,
  keep = 11,
  precision = 15,
  factor = 10,
  bl_noise = 0
)
}
\arguments{
\item{data}{time versus intensity dataframe.}

\item{begin_search}{time at which to start the search for the peaks.}

\item{end_search}{time at which to stop the search for the peaks.}

\item{keep}{a whole number indicating how many peaks to search for and return.}

\item{precision}{an integer indicating the size of the window for searching for local maxima.}

\item{factor}{constant of proportionality indicating the cutoff peak height (i.e., peaks greater than `factor` times height are not returned as viable peaks).}

\item{bl_noise}{constant level at which response should be considered as noise.}
}
\value{
list containing spectra maxima,the times they occur at, the index
location of the maxima, and the the same info for the next viable peaks with
times after the first `keep`.
}
\description{
Returns the maxima, the times they occur at, the index location of the maxima, and the next viable peaks with times after the first `keep`.
}
