% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA.reg.r
\name{y2DA}
\alias{y2DA}
\title{Convert DA to (classical) regression}
\usage{
y2DA(A = 0, B = 1, S = NA)
}
\arguments{
\item{A}{Intercept in the linear relation of y1 on y2.}

\item{B}{Slope in the linear relation of y1 on y2.}

\item{S}{SD for the linear relation of y1 on y2. Can be \code{NA}.}
}
\value{
\code{y2DA} returns a 3-component vector with names
\code{c("DA-int","DA-slope","DA-sd")}, referring to differences
\code{D=y1-y2} as a linear function of \code{A=(y1+y2)/2}.
}
\description{
The functions \code{DA2y} and \code{y2DA} are convenience functions that
convert the estimates of intercept, slope and sd from the regression of
\eqn{D=y_1-y_2}{D=y1-y2} on \eqn{A=(y_1+y_2)/2}{A=(y1+y2)/2}, back and forth
to the resulting intercept, slope and sd in the relationship between
\eqn{y_1}{y1} and \eqn{y_2}{y2}, cf. Carstensen (2010), equation 6.
}
\details{
#' \code{y2DA} takes intercept(\code{A}), slope(\code{B}) and sd(\code{S}) from
the relationship \code{y1=A+B y2 + E} with sd(\code{E})=\code{E}, and
returns a vector of length 3 with names
\code{"int(t-f)","slope(t-f)","sd(t-f)"}, where \code{t} refers to "to"
(\code{y1} and \code{f} to "from" \code{y2}.
}
\examples{
data( milk )
DA.reg( milk )
data( sbp )
print( DA.reg(sbp), digits=3 )
# Slope, intercept : y1 = 0.7 + 1.2*y2 (0.4)
A <- c(0.7,1.2,0.4)
( y2DA( A ) )
( DA2y( y2DA( A ) ) )

}
\references{
B. Carstensen: Comparing methods of measurement: Extending the
LoA by regression.  Stat Med, 29:401-410, 2010.
}
\author{
Bendix Carstensen, Steno Diabetes Center, \email{bendix.carstensen@regionh.dk},
\url{https://BendixCarstensen.com/MethComp/}
}
