% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.MCmcmc.R
\name{trace.MCmcmc}
\alias{trace.MCmcmc}
\alias{check.MCmcmc}
\alias{post.MCmcmc}
\title{Functions to graphically assess the convergence of the MCMC-simulation in a
MCmcmc object}
\usage{
\method{trace}{MCmcmc}(
  obj,
  what = "sd",
  scales = c("same", "free"),
  layout = "col",
  aspect = "fill",
  ...
)
}
\arguments{
\item{obj}{A \code{MCmcmc} object.}

\item{what}{Character indicating what parameters to plot.  Possible values
are \code{"sd"} or \code{"var"} which gives plots for the variance
components (on the sd. scale), \code{"beta"} or \code{"slope"}, which gives
plots for slope parameters and \code{"alpha"} or \code{"int"}, which gives
plots for the intercept parameters.}

\item{scales}{Character vector of length two, with possible values "same" or
"free", indicating whether x- and y-axes of the plots should be constrained
to be the same across panels. For \code{pairs} only the first element is
used to decide whether all panles should have the same axes.}

\item{layout}{Character. If \code{"col"} parameters are displayed columnwise
by method, if \code{"row"} they are displayed row-wise.}

\item{aspect}{How should the panels be scaled. Default (\code{"fill"}) is to
make a panels take up as much place as possible.}

\item{\dots}{Further aruments passed on to the \code{\link[lattice]{Lattice}} package}
}
\value{
A \code{\link[lattice]{Lattice}} plot.
}
\description{
These functions display traces for the relevant subset of the parameters in a MCmcmc object.
}
\details{
A \code{lattice} plot is returned, which means that it must \code{print}ed
when these functions are called in a batch program or inside another
function or for-loop.

\code{trace} plots traces of the sampled chains, \code{post} plots posterior
densities of the parameters and \code{pairs} plots a scatter-plot matrix of
bivariate marginal posterior distributions.
}
\examples{

# Load a provided MCmcmc object
data( ox.MC )
trace.MCmcmc( ox.MC, what="beta" )
pairs( ox.MC, what="sd" )

}
\seealso{
\code{\link{MCmcmc}}, \code{\link{plot.MCmcmc}},
\code{\link{ox.MC}}, \code{\link{sbp.MC}}
}
\author{
Bendix Carstensen, Steno Diabetes Center, \email{bendix.carstensen@regionh.dk },
\url{https://BendixCarstensen.com}.
}
\keyword{models}
