% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ci_to_var}
\alias{ci_to_var}
\title{Calculate variance given confidence interval limit and point estimate}
\usage{
ci_to_var(est, ci.lim, ci.level = 0.95, df = NA)
}
\arguments{
\item{est}{Point estimate}

\item{ci.lim}{Lower or upper confidence interval limit}

\item{ci.level}{Confidence interval level as a proportion (e.g., 0.95)}

\item{df}{Degrees of freedom}
}
\description{
Returns approximate variance (i.e., squared standard error) of point estimate given either the upper or lower limit (\code{ci.lim}) of a Wald-type confidence interval. If degrees of freedom (\code{df}) are not provided, it is assumed that the confidence interval uses a z-distribution approximation. If degrees of freedom are provided, it is assumed that the confidence interval uses a t-distribution approximation.
}
\details{
The estimate and confidence interval must be provided on a scale such that the confidence interval is symmetric. For example, if the point estimate is a relative risk, then the estimate and confidence interval should be provided on the log-relative risk scale.
}
