% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_plot.R
\name{forest_plot}
\alias{forest_plot}
\title{Plot a forest plot}
\source{
This function is based \code{foresplot} function from \code{foresplot}
R package.
}
\usage{
forest_plot(
  x = NULL,
  labels = NULL,
  digits = 2,
  boxsize = 0.3,
  heterogeneity = TRUE,
  col,
  ...
)
}
\arguments{
\item{x}{A \code{meta_stan} object.}

\item{labels}{Optional vector with labels for the studies (publication author/year).}

\item{digits}{A numerical value specifying the number of significant digits to be shown.
Default is 2.}

\item{boxsize}{A numerical value specifying the box size. Default is 0.3.}

\item{heterogeneity}{A logical value to include heterogeneity estimates (DEFAULT = TRUE)}

\item{col}{A function specifying the colors. See \code{forestplot::fpColors} for details.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The return value is invisible \code{NULL}.
}
\description{
Takes a \code{meta_stan} object which is obtained by function \code{meta_stan} and plot
a forestplot, showing individual estimates along with their 95 percent credible intervals,
resulting effect estimate and prediction interval.
}
\examples{
\dontrun{
data('dat.Crins2014', package = "MetaStan")
dat_long <- create_MetaStan_dat(dat = dat.Crins2014,
                                    armVars = c(responders = "r", sampleSize = "n"))
bnhm.Crins  <- meta_stan(data = dat_long, likelihood = "binomial",
                         mu_prior = c(0, 10), theta_prior = c(0, 100),
                         tau_prior =  0.5)
forest_plot(bnhm.Crins, xlab = "log-OR", labels = dat.Crins2014$publication)

}
}
\seealso{
\code{foresplot::foresplot}
}
\author{
Christian Roever and Burak Kuersad Guenhan
}
