% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{smoking_tbl_df}
\alias{smoking_tbl_df}
\title{UK Smoking Data}
\format{
A tibble with 1,691 observations and 12 variables:
\describe{
  \item{gender}{A factor indicating the gender of the respondent (e.g., male, female).}
  \item{age}{An integer representing the age of the respondent.}
  \item{marital_status}{A factor indicating the marital status of the respondent (e.g., single, married).}
  \item{highest_qualification}{A factor indicating the highest qualification attained by the respondent.}
  \item{nationality}{A factor indicating the nationality of the respondent.}
  \item{ethnicity}{A factor indicating the ethnicity of the respondent.}
  \item{gross_income}{A factor indicating the gross income level of the respondent.}
  \item{region}{A factor indicating the geographical region of the respondent.}
  \item{smoke}{A factor indicating whether the respondent is a smoker (e.g., yes, no).}
  \item{amt_weekends}{An integer representing the amount smoked on weekends.}
  \item{amt_weekdays}{An integer representing the amount smoked on weekdays.}
  \item{type}{A factor indicating the type of smoking behavior (e.g., occasional, regular).}
}
}
\source{
Data collected from UK health surveys focusing on smoking behavior.
}
\usage{
data(smoking_tbl_df)
}
\description{
The dataset name has been changed to 'smoking_tbl_df' to avoid confusion with other datasets from
packages in the R ecosystem and to follow the naming conventions of the 'MedDataSets' package.
The suffix '_tbl_df' indicates that this dataset is a tibble, helping to distinguish it from
other datasets within the package and from those in the broader R ecosystem. The original content
of the dataset has not been modified in any way.
}
\details{
This dataset contains information on smoking habits in the UK, focusing on various demographic
factors and smoking behaviors. It provides insights into smoking patterns among different groups
of people, helping to inform public health strategies.
}
