% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w.R
\name{w}
\alias{w}
\title{Solar time angle}
\usage{
w(x, long.deg, control = list(Lz = 345))
}
\arguments{
\item{x}{date-time object (e.g, POSIXct, POSIXlt or Date objects).}

\item{long.deg}{longitude of the measurement site (degrees east of Greenwich) (for periods < 1 day)}

\item{control}{list for control parameters and empirical factors (see Details)}
}
\description{
Solar time angle at midpoint of the period (for periods < 1 day).
}
\details{
\describe{\item{control:}{
Lz: \cr
longitude of the centre of the local time zone (degrees west of Greenwich) \cr
- 0 for Greenwich \cr
- 345 for Germany \cr
- 330 for Cairo (Egypt) \cr
- 255 for Bangkok (Thailand) \cr
- 75, 90, 105 and 120 for the Eastern, Central, Rocky Mountain and Pacific time zones (United States)}
}
}
\note{
eq. 31 of reference
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998). Crop evapotranspiration-Guidelines for computing crop water requirements-FAO Irrigation and drainage paper 56. FAO, Rome, 300(9).
}
