% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_selectWhere.R
\name{mts_selectWhere}
\alias{mts_selectWhere}
\title{Data-based subsetting of time series within an \emph{mts} object.}
\usage{
mts_selectWhere(mts, FUN)
}
\arguments{
\item{mts}{\emph{mts} object.}

\item{FUN}{A function applied to time series data that returns TRUE or FALSE.}
}
\value{
A subset of the incoming \emph{mts} object. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Subsetting of \code{mts} acts similarly to \code{tidyselect::where()} working on
\code{mts$data}. The returned \emph{mts} object will contain only
those time series where \code{FUN} applied to the time series data returns \code{TRUE}.
}
\examples{
library(MazamaTimeSeries)

# Show all Camp_Fire locations
Camp_Fire$meta$locationName

# Set a threshold
threshold <- 500

# Find time series with data at or above this threshold
worst_sites <-
  Camp_Fire \%>\%
  mts_selectWhere(
    function(x) { any(x >= threshold, na.rm = TRUE) }
  )

# Show the worst locations
worst_sites$meta$locationName

}
\seealso{
\link{mts_select}
}
