% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/US_countryConversion.R
\name{countryConversion}
\alias{countryConversion}
\alias{countryCodeToName}
\alias{countryCodeToFIPS}
\alias{countryFIPSToName}
\alias{countryFIPSToCode}
\alias{countryNameToCode}
\alias{countryNameToFIPS}
\title{Conversion functions for country names, codes and FIPS codes.}
\usage{
countryCodeToName(countryCode = NULL)

countryCodeToFIPS(countryCode = NULL)

countryFIPSToName(countryFIPS = NULL)

countryFIPSToCode(countryFIPS = NULL)

countryNameToCode(countryName = NULL)

countryNameToFIPS(countryName = NULL)
}
\arguments{
\item{countryCode}{Vector of ISO 3166-1 alpha-2 codes.}

\item{countryFIPS}{Vector of two-character FIPS codes.}

\item{countryName}{Vector of English language country names.}
}
\value{
A vector of country names or codes.
}
\description{
Converts a vector of country names or codes from one system to
another returning \code{NA} where no match is found.
}
\examples{
library(MazamaSpatialUtils)

# FIPS codes are different!

countryNameToCode("Germany")
countryNameToFIPS("Germany")

countryCodeToName("CH")
countryFIPSToName("CH")

countryCodes <- sample(SimpleCountries$countryCode, 30)

data.frame(
  name = countryCodeToName(countryCodes),
  code = countryCodes,
  FIPS = countryCodeToFIPS(countryCodes)
)

}
