% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createLocationMask.R
\name{createLocationMask}
\alias{createLocationMask}
\title{Create a mask of valid locations}
\usage{
createLocationMask(
  longitude = NULL,
  latitude = NULL,
  lonRange = c(-180, 180),
  latRange = c(-90, 90),
  removeZeroZero = TRUE
)
}
\arguments{
\item{longitude}{Vector of longitudes in decimal degrees E.}

\item{latitude}{Vector of latitudes in decimal degrees N.}

\item{lonRange}{Range of valid longitudes.}

\item{latRange}{Range of valid latitudes.}

\item{removeZeroZero}{Logical indicating whether locations at \code{0.0, 0.0}
should be marked as invalid.}
}
\value{
Vector of logical values.
}
\description{
A logical vector is created with either \code{TRUE} or
\code{FALSE} for each incoming \code{longitude, latitude} pair with
\code{TRUE} indicating a valid location. This can be used to filter dataframes
to retain only records with valid locations.

\code{lonRange} and \code{latRange} can be used to create a valid-mask for
locations within a rectangular area.

\code{removeZeroZero} will invalidate the location \code{0.0, 0.0} which is
sometimes seen in poorly QC'ed datasets.

\code{NA} values found in \code{longitude} or \code{latitude} will result
in a mask value of \code{FALSE}.
}
\examples{
library(MazamaCoreUtils)

createLocationMask(
  longitude = c(-120, NA, -120, -220, -120, 0),
  latitude = c(45, 45, NA, 45, 100, 0)
)

createLocationMask(
  longitude = c(-120:-90),
  latitude = c(20:50),
  lonRange = c(-110, -100),
  latRange = c(30, 40)
)

}
