% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.mc}
\alias{print.mc}
\title{Print a Summary of a \code{mc} Object}
\usage{
\method{print}{mc}(x, digits = getOption("digits"), ...)
}
\arguments{
\item{x}{an object used to select a method.}

\item{digits}{minimal number of \emph{significant} digits, see
    \code{\link[base]{print.default}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The \code{mc} object is returned invisibly.
}
\description{
This is a method for the function \code{print()} for objects of the
class \code{mc}.
}
\examples{
## Example
# Set seed
set.seed(999)

# Generate sample data
y <- rgamma(8, shape = 2, rate = 1)

# Set data generating process function
dgp <- function(y)  rgamma(length(y), shape = 2, rate = 1)

# Set the statistic function to the Kolomogorov-Smirnov test for gamma distribution
statistic <- function(y){
    out <- ks.test(y, "pgamma", shape = 2, rate = 1)
    return(out$statistic)
}

# Apply the Monte Carlo test with tie-breaker
est <- mc(y, statistic = statistic, dgp = dgp, N = 999, type = "two-tailed")

# Print result of object of class 'mc'
print(est)
}
