% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is.mimipo}
\alias{is.mimipo}
\title{Checks for the \code{mimipo} Class}
\usage{
is.mimipo(object)
}
\arguments{
\item{object}{This argument specifies the object that should be checked to see if it is of the \code{mimipo} class or not.}
}
\value{
This function returns a logical value indicating whether \code{object} is of the \code{mimipo} class.
}
\description{
\code{is.mimipo()} function checks whether class of objects is \code{mimipo} or not.
}
\details{
The class of objects is checked to be of the \code{mimipo}.
}
\examples{
\donttest{#Loading libraries
library(survey)

#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice::mice(osteoarthritis, m = 5)

#Estimating weights of observations in the multiply imputed datasets
weighted.datasets <- weightthem(OSP ~ AGE + SEX + BMI + RAC + SMK,
                                imputed.datasets,
                                approach = 'within',
                                method = 'glm',
                                estimand = "ATT")

#Analyzing the weighted datasets
models <- with(data = weighted.datasets,
               exp = svyglm(KOA ~ OSP, family = binomial))

#Pooling results obtained from analysing the datasets
results <- pool(models)

#Checking the 'results' object
is.mimipo(results)}
}
\seealso{
\code{\link[=pool]{pool()}}

\code{\link[=mimipo]{mimipo()}}
}
\author{
Farhad Pishgar
}
