% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-functions.R
\name{plot_magmaclust}
\alias{plot_magmaclust}
\title{Plot MagmaClust predictions}
\usage{
plot_magmaclust(
  pred_clust,
  cluster = "all",
  x_input = NULL,
  data = NULL,
  data_train = NULL,
  col_clust = FALSE,
  prior_mean = NULL,
  y_grid = NULL,
  heatmap = FALSE,
  samples = FALSE,
  nb_samples = 50,
  plot_mean = TRUE,
  alpha_samples = 0.3,
  prob_CI = 0.95,
  size_data = 3,
  size_data_train = 1,
  alpha_data_train = 0.5
)
}
\arguments{
\item{pred_clust}{A list of predictions, typically coming from
\code{\link{pred_magmaclust}}. Required elements: \code{pred},
\code{mixture}, \code{mixture_pred}.}

\item{cluster}{A character string, indicating which cluster to plot from.
If 'all' (default) the mixture of GPs prediction is displayed as a mean
curve (1-D inputs) or a mean heatmap (2-D inputs). Alternatively, if the
name of one cluster is provided, the classic mean curve + credible
interval is displayed (1-D inputs), or a heatmap with colour gradient for
the mean and transparency gradient for the Credible Interval (2-D inputs).}

\item{x_input}{A vector of character strings, indicating which input should
be displayed. If NULL (default) the 'Input' column is used for the x-axis.
If providing a 2-dimensional vector, the corresponding columns are used
for the x-axis and y-axis.}

\item{data}{(Optional) A tibble or data frame. Required columns: \code{Input}
, \code{Output}. Additional columns for covariates can be specified. This
argument corresponds to the raw data on which the prediction has been
performed.}

\item{data_train}{(Optional) A tibble or data frame, containing the training
data of the MagmaClust model. The data set should have the same format as
the \code{data} argument with an additional required column \code{ID} for
identifying the different individuals/tasks. If provided, those data are
displayed as backward colourful points (each colour corresponding to one
individual or a cluster, see \code{col_clust} below).}

\item{col_clust}{A boolean indicating whether backward points are coloured
according to the individuals or to their most probable cluster. If one
wants to colour by clusters, a column \code{Cluster} shall be present in
\code{data_train}. We advise to use \code{\link{data_allocate_cluster}}
for automatically creating a well-formatted dataset from a trained
MagmaClust model.}

\item{prior_mean}{(Optional) A list providing, for each cluster, a
tibble containing prior mean parameters of the prediction. This argument
typically comes as an outcome \code{hyperpost$mean}, available through
the \code{\link{train_magmaclust}}, \code{\link{pred_magmaclust}}
functions.}

\item{y_grid}{A vector, indicating the grid of values on the y-axis for which
probabilities should be computed for heatmaps of 1-dimensional
predictions. If NULL (default), a vector of length 50 is defined, ranging
between the min and max 'Output' values contained in \code{pred}.}

\item{heatmap}{A logical value indicating whether the GP mixture should be
represented as a heatmap of probabilities for 1-dimensional inputs. If
FALSE (default), the mean curve (and associated Credible Interval if
available) are displayed.}

\item{samples}{A logical value indicating whether the GP mixture should be
represented as a collection of samples drawn from the posterior. If
FALSE (default), the mean curve (and associated Credible Interval if
available) are displayed.}

\item{nb_samples}{A number, indicating the number of samples to be drawn from
the predictive posterior distribution. For two-dimensional graphs, only
one sample can be displayed.}

\item{plot_mean}{A logical value, indicating whether the mean prediction
should be displayed on the graph when \code{samples = TRUE}.}

\item{alpha_samples}{A number, controlling transparency of the sample curves.}

\item{prob_CI}{A number between 0 and 1 (default is 0.95), indicating the
level of the Credible Interval associated with the posterior mean curve.
If this this argument is set to 1, the Credible Interval is not displayed.}

\item{size_data}{A number, controlling the size of the \code{data} points.}

\item{size_data_train}{A number, controlling the size of the
\code{data_train} points.}

\item{alpha_data_train}{A number, between 0 and 1, controlling transparency
of the \code{data_train} points.}
}
\value{
Visualisation of a MagmaClust prediction (optional: display data
points, training data points and the prior mean functions). For 1-D
inputs, the prediction is represented as a mean curve (and its associated
95\% Credible Interval for cluster-specific predictions), or as a heatmap
of probabilities if \code{heatmap} = TRUE. In the case of MagmaClust,
the heatmap representation should be preferred for clarity, although the
default display remains mean curve for quicker execution. For 2-D inputs,
the prediction is represented as a heatmap, where each couple of inputs on
the x-axis and y-axis are associated with a gradient of colours for the
posterior mean values, whereas the uncertainty is indicated by the
transparency (the narrower is the Credible Interval, the more opaque is
the associated colour, and vice versa). As for 1-D inputs, Credible
Interval information is only available for cluster-specific predictions.
}
\description{
Display MagmaClust predictions. According to the dimension of the
inputs, the graph may be a mean curve (dim inputs = 1) or a heatmap
(dim inputs = 2) of probabilities. Moreover, MagmaClust can provide credible
intervals only by visualising cluster-specific predictions (e.g. for the most
probable cluster). When visualising the full mixture-of-GPs prediction,
which can be multimodal, the user should choose between the simple mean
function or the full heatmap of probabilities (more informative but slower).
}
\examples{
TRUE
}
