% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maoea.R
\name{optimMaOEA}
\alias{optimMaOEA}
\title{Elitist Non-dominated Sorting Genetic Algorithm version III}
\usage{
optimMaOEA(
  x = NULL,
  fun,
  solver = NSGA3,
  nObjective,
  nGeneration = 1,
  nVar = nrow(x),
  populationSize = ncol(x),
  seed = 2000,
  control = list(),
  ...
)
}
\arguments{
\item{x}{The initial population. If not supplied, will be generated using LHS. Column major, each column contain one entry.}

\item{fun}{Objective function being solved.}

\item{solver}{Function name of the solver. Currently available: SMSEMOA, MOCMAES, SMOCMAES, and NSGA3.}

\item{nObjective}{The number of objective functions. A scalar value.}

\item{nGeneration}{Optional, the number of generation the solver should run.}

\item{nVar}{Number of variables, will be used if \code{x} is not given.}

\item{populationSize}{Number of individuals in the population, will be used if \code{x} is not given.}

\item{seed}{random number seed for reproduction of code}

\item{control}{A list, containing the following:
\code{weightVectorSet} A set of weight vector for the optimizer. The weight vector can be any point in the objective space. If not supplied, 5*nObjective points are generated from a sobol sequence. Size: nrow = nObjective,ncol = number of weight vectors
\code{crossoverProbability} The probability of doing crossover. Should be between 0-1. Negative value will behave like a zero, and values larger than 1 will behave like 1. Default to 1.
\code{mutationProbability} The probability of doing mutation. Should be between 0-1. Negative value will behave like a zero, and values larger than 1 will behave like 1. Default to 1
\code{WFGScaling} The use of scaling factor in WFG. Will be ignored in DTLZ problems. Without the scaling, the Pareto front would be on the all-positive portion of hypersphere with radius 1.
\code{mutationDistribution} The distribution index for polynomial mutation. Larger index makes the distribution sharper around the parent.
\code{crossoverDistribution} The distribution index for SBX. Larger index makes the distribution sharper around each parent.}

\item{...}{Further arguments to be passed to \code{fun}}
}
\value{
Returns a list for the next generation
\code{population} The new generation design points.
\code{populationObjective} The new generation's objective values.
}
\description{
Main interface for the many-objective optimization evolutionary algorithm (MaOEA) package.
}
\examples{
\donttest{
nVar <- 14
nObjective <- 5
nIndividual <- 100
#control for NSGA3
ctrl <- list(crossoverProbability = 1,
             mutationProbability = 1/nVar)
#Initial population can be supplied, like below but for this example, we skip it
#population <- matrix(runif(nIndividual*nVar), nrow = nVar)

numpyready <- reticulate::py_module_available('numpy')
pygmoready <- reticulate::py_module_available('pygmo')
py_module_ready <- numpyready && pygmoready
if(py_module_ready){ # prevent error on testing the example
# Hybrid NSGA-III and SMSEMOA example
# 2 calls for nObjective. 1 for optimMaOEA, 1 for WFG8
# generate initial population and run 10 gen. NSGA-III with standard WFG8 test function.
newPop <- optimMaOEA( , WFG8,NSGA3,nObjective,10,nVar,nIndividual,,ctrl,nObjective)$x

# run 5 generations of SMSEMOA with standard WFG8 test function starting with newPop.
result <- optimMaOEA( newPop, WFG8,SMSEMOA,nObjective,5,,,1000,ctrl,nObjective)
finalPop <- result$x
finalObjective <- result$y
}
}
}
