% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MT.R
\name{diagnosis.MT}
\alias{diagnosis.MT}
\title{Diagnosis method for the Mahalanobis-Taguchi (MT) method}
\usage{
\method{diagnosis}{MT}(unit_space, newdata, threshold = 4,
  includes_transformed_newdata = FALSE)
}
\arguments{
\item{unit_space}{Object of class "MT" generated by \code{\link{MT}} or
\code{\link{generates_unit_space}}(..., method = "MT").}

\item{newdata}{Matrix with n rows (samples) and p columns (variables). The
data are used to calculate the desired distances from the
unit space. All data should be continuous values and should
not have missing values.}

\item{threshold}{Numeric specifying the threshold value to classify each
sample into positive (\code{TRUE}) or negative
(\code{FALSE}).}

\item{includes_transformed_newdata}{If \code{TRUE}, then the transformed data
for \code{newdata} are included in a
return object.}
}
\value{
\code{diagnosis.MT} (via \code{\link{diagnosis}}) returns a list
          containing the following components:

 \item{distance}{Vector with length n. Distances from the unit space to each
                  sample.}
 \item{le_threshold}{Vector with length n. Logical values indicating the
                      distance of each sample is less than or equal to the
                      threhold value (\code{TRUE}) or not (\code{FALSE}).}
 \item{threshold}{Numeric value to classify the sample into positive or
                   negative.}
 \item{unit_space}{Object of class "MT" passed by \code{unit_space}.}
 \item{n}{The number of samples for \code{newdata}.}
 \item{q}{The number of variables after the data transformation. q equals p.}
 \item{x}{If \code{includes_transformed_newdata} is \code{TRUE}, then the
           transformed data for \code{newdata} are included.}
}
\description{
\code{diagnosis.MT} (via \code{\link{diagnosis}}) calculates the
  mahalanobis distance based on the unit space generated by \code{\link{MT}}
  or \code{\link{generates_unit_space}}(..., method = "MT") and classifies
  each sample into positive (\code{TRUE}) or negative (\code{FALSE}) by
  comparing the values with the set threshold value.
}
\examples{
# 40 data for versicolor in the iris dataset
iris_versicolor <- iris[61:100, -5]

unit_space_MT <- MT(unit_space_data = iris_versicolor,
                    includes_transformed_data = TRUE)

# 10 data for each kind (setosa, versicolor, virginica) in the iris dataset
iris_test <- iris[c(1:10, 51:60, 101:111), -5]

diagnosis_MT <- diagnosis(unit_space = unit_space_MT,
                          newdata = iris_test,
                          threshold = 4,
                          includes_transformed_newdata = TRUE)

(diagnosis_MT$distance)
(diagnosis_MT$le_threshold)

}
\references{
Taguchi, G. (1995). Pattern Recognition and Quality Engineering (1).
    \emph{Journal of Quality Engineering Society, 3}(2), 2-5. (In Japanese)

  Taguchi, G., Wu, Y., & Chodhury, S. (2000).
    \emph{Mahalanobis-Taguchi System.} McGraw-Hill Professional.

  Taguchi, G., & Jugulum, R. (2002). \emph{The Mahalanobis-Taguchi strategy:
    A pattern technology system.} John Wiley & Sons.

  Woodall, W. H., Koudelik, R., Tsui, K. L., Kim, S. B., Stoumbos, Z. G., &
    Carvounis, C. P. (2003). A review and analysis of the Mahalanobis-Taguchi
    system. \emph{Technometrics, 45}(1), 1-15.
}
\seealso{
\code{\link{general_diagnosis.MT}} and \code{\link{MT}}
}

