% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation.R
\name{segmentation}
\alias{segmentation}
\title{Detecting common change points for multiple signals.}
\usage{
segmentation(Y, lambda, flag = TRUE, return_smooth_signals = TRUE)
}
\arguments{
\item{Y}{An data.frame/matrix containing the data to be segmented. Each column stores a signal.}

\item{lambda}{A penalty term, small value leads to large number of breakpoints, and vice versa.}

\item{flag}{Logical. If True then use th PELT method. If False then use the OP method.}

\item{return_smooth_signals}{Logical. If True then smoothed signals are returned.}
}
\value{
An object of S4 class "MSigSeg"
}
\description{
Calculates the optimal positioning and number of common breakpoints for multiple signals.
}
\details{
This function uses modified PELT method to find optimal common change points for multiple signals.
}
\examples{
data(data_test)
segmentation(data_test,100)

}
