% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Survey_Weight_Adjustment.R
\name{WFPBB}
\alias{WFPBB}
\title{Weighted Finite Population Bayesian Bootstrap}
\usage{
WFPBB(y, w, N, n, verbatim)
}
\arguments{
\item{y}{The index of survey data.}

\item{w}{Survey weights. The summation of survey weights should equal the population size}

\item{N}{The population size.}

\item{n}{The sample size.}

\item{verbatim}{TRUE/FALSE. This variable decides whether print the progress information to the console.}
}
\value{
The re-sampled index of survey data.
}
\description{
The function is implemented based on the WFPBB algorithm from \insertCite{Gunawan2020}{MSIMST}.
}
\examples{
set.seed(100)
output_data <- reg_simulation3(N = 5000,
                               ni_lambda= 8,
                               beta = c(rep(1,6),rep(0,4)),
                               beta_b = 1.5,
                               dsq = 0.1,
                               sigmasq = 0.5,
                               delta = 0.6,
                               nu = 5.89,
                               muz = 0,
                               rho = 36.0,
                               sigmasq_z = 0.6,
                               zeta0 = -1.8,
                               zeta1 = 0.1)
y <- output_data$y
X <- output_data$X
survey_weight <- output_data$survey_weight
# set the population size
population_N <- 5000
# set the sample size
n <- length(y)
# run the WFPBB algorithm
index_WFPBB <- WFPBB(y = 1:n,
                     w = survey_weight,
                     N = population_N,
                     n = n,
                     verbatim = FALSE)
print(head(index_WFPBB))

}
\references{
\insertRef{Gunawan2020}{MSIMST}
}
