# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' The Function to Calculate the phiX Matrix for Estimating Single-Index Function
#' 
#' @param Xbeta The single index values. A vector of length n.
#' @param u The vector spanning from -1 to 1 with length L + 1.
#' @param L An integer defining the number of nodes.
#' @return A n by L + 1 matrix.
#' @examples
#' L <- 50
#' u <- seq(-1,1,length.out = L + 1)
#' phiX <- phiX_c(0.5,u,L)
#' print(phiX)
#' @description
#' The function \verb{phiX_c} is used to generate the phiX matrix associated with the Gaussian process prior.
#' 
#' @export
phiX_c <- function(Xbeta, u, L) {
    .Call(`_MSIMST_phiX_c`, Xbeta, u, L)
}

cs_inv_c <- function(dsq, sigmasq, n) {
    .Call(`_MSIMST_cs_inv_c`, dsq, sigmasq, n)
}

b_func_c <- function(nu) {
    .Call(`_MSIMST_b_func_c`, nu)
}

cs_det_c <- function(dsq, sigmasq, n) {
    .Call(`_MSIMST_cs_det_c`, dsq, sigmasq, n)
}

mvt_lpdf_c <- function(x_vec, mu_vec, Sigma_inv, Sigma_det, nu) {
    .Call(`_MSIMST_mvt_lpdf_c`, x_vec, mu_vec, Sigma_inv, Sigma_det, nu)
}

mst_lpdf_c <- function(x_vec, loc_value, dsq, sigmasq, delta, nu) {
    .Call(`_MSIMST_mst_lpdf_c`, x_vec, loc_value, dsq, sigmasq, delta, nu)
}

Dbeta <- function(L, t) {
    .Call(`_MSIMST_Dbeta`, L, t)
}

rtmvnormHMC <- function(n, mu, Sigma, x_init, ff, gg, n_burn) {
    .Call(`_MSIMST_rtmvnormHMC`, n, mu, Sigma, x_init, ff, gg, n_burn)
}

