% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UncVol.R
\name{UncVol}
\alias{UncVol}
\alias{UncVol.MSGARCH_SPEC}
\alias{UncVol.MSGARCH_ML_FIT}
\alias{UncVol.MSGARCH_MCMC_FIT}
\title{Unconditional volatility.}
\usage{
UncVol(object, ...)

\method{UncVol}{MSGARCH_SPEC}(object, par = NULL, ctr = list(), ...)

\method{UncVol}{MSGARCH_ML_FIT}(object, ctr = list(), ...)

\method{UncVol}{MSGARCH_MCMC_FIT}(object, ctr = list(), ...)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC}
created with \code{\link{CreateSpec}} or fit object of type \code{MSGARCH_ML_FIT}
created with \code{\link{FitML}} or \code{MSGARCH_MCMC_FIT}
created with \code{\link{FitMCMC}}.}

\item{...}{Not used. Other arguments to \code{UncVol}.}

\item{par}{Vector (of size d) or matrix (of size \code{nmcmc} x d) of parameter
estimates where d must have
the same length as the default parameters of the specification.}

\item{ctr}{A list of control parameters:
\itemize{
\item \code{nsim} (integer >= 0) :
Number of simulations used for the estimation of the
unconditional volatility. (Default: \code{nsim = 250L})
\item \code{nahead} (integer >= 0) :
Number of step ahead performed to estimate the
unconditional volatility .(Default: \code{nahead = 5000L})
\item \code{nburn} (integer >= 0) :
Number of discarded step to estimate the
unconditional volatility. (Default: \code{nburn = 1000L})
}}
}
\value{
A \code{scalar} of unconditional volatility.
}
\description{
Method returning the unconditional volatility of the process.
}
\details{
If a matrix of MCMC posterior draws is given, the
Bayesian unconditional volatility is calculated.
 The unconditional volatility is estimated by first simulating \code{nsim}
 paths up to \code{nburn + nahead},
 calculating a forecast of the conditional volatility at each step ahead,
 discarding the first \code{nburn} step ahead conditional volatilities forecasts,
 and computing the mean of the remaining \code{nahead - nburn} conditional
 volatilites forecasts. This method is based on the fact that
 the conditional volatility forecast will converge to the unconditional volatilty
 the further the forecast his from the starting point.
 We take the average as a way to remove the noise that comes with the simulation process.
 Overall, this method allows to compute the unconditional volatilty complex models.
}
\examples{
# create specification
spec <- CreateSpec()

\dontrun{
# unconditional volatility from specification
par <- c(0.1, 0.1, 0.8, 0.2, 0.1, 0.8, 0.99, 0.01)
UncVol(object = spec, par = par)

# load data
data("SMI", package = "MSGARCH")

# unconditional volatility from ML fit
fit <- FitML(spec = spec, data = SMI)
UncVol(object = fit)
var(SMI)

# unconditional volatility from MCMC fit
set.seed(1234)
fit <- FitMCMC(spec = spec, data = SMI)
UncVol(object = fit)
}
}
