% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_nuisance_config.R
\name{mcee_config_lm}
\alias{mcee_config_lm}
\title{Configure linear model for MCEE nuisance parameters}
\usage{
mcee_config_lm(target, formula)
}
\arguments{
\item{target}{Character. Nuisance parameter name ("p", "q", "eta", "mu", "nu").}

\item{formula}{RHS-only formula (e.g., \code{~ X1 + X2 + poly(dp, 2)}).}
}
\value{
A configuration list for use with \code{\link{mcee_general}}.
}
\description{
Creates a configuration to fit nuisance parameters using linear models
via \code{stats::lm()}. Only appropriate for continuous outcomes.
}
\examples{
# Linear model for continuous outcome
cfg_eta <- mcee_config_lm("eta", ~ dp + X1 + X2)
}
