% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{negNLL}
\alias{negNLL}
\title{negNLL  -ve log-likelihood for normally distributed variables}
\usage{
negNLL(pars, funk, observed, ...)
}
\arguments{
\item{pars}{a vector containing the parameters being used in funk, 
plus the sigma, which is the standard deviation of the normal 
random likelihoods in dnorm, an extra estimated parameter.
Because negNLL refers explicitly to sigma, which must be the 
last parameter in the vector, it must be listed in the arguments.}

\item{funk}{the function name that calculates the predicted values 
from the independent values passed using the ellipsis.}

\item{observed}{the observed values of the variable that the model 
will predict to compare with each of the input observed values.}

\item{...}{required to allow funk to access its other input data
without having to explicitly define them in negNLL}
}
\value{
the sum of the negative log-likelihoods using a normal PDF
}
\description{
negNLL - Calculates the negative log-likelihood for
    normally distributed variables. It requires a function, 'funk' 
    as an argument, that will calculate predicted values of a 
    variable from a vector of input values. In the example below the
    predicted values are lengths-at-age and the input data are ages.
    Only the arguments used within negNLL are listed explicitly, 
    which leaves the data required to drive the funk to generate the
    predicted values for comparison with the observed to be passed 
    using the ..., so take care with spelling of the variable name
    required by whatever funk is being used.
}
\examples{
 data(minnow)
 pars <- c(89, 0.01,-15,3.75)  # ssq    = 785.6183
 age <- minnow$week            # negNLL = 151.1713
 ssq(funk=vB,observed=minnow$length,p=pars,ages=age)
 negNLL(pars,funk=vB,observed=minnow$length,ages=age)
 oldpar <- par(no.readonly=TRUE)
 plot1(age,vB(pars,age),xlab="Age",ylab="Length",lwd=2)
 points(age,minnow$length,pch=16,cex=1.2)
 par(oldpar)
}
