% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v.chi.sq.R
\name{v.chi.sq}
\alias{v.chi.sq}
\title{V for Chi-Square}
\usage{
v.chi.sq(x2, n, r, c, a = 0.05)
}
\arguments{
\item{x2}{chi-square statistic}

\item{n}{sample size}

\item{r}{number of rows in the contingency table}

\item{c}{number of columns in the contingency table}

\item{a}{significance level}
}
\value{
Provides V with associated confidence intervals
and relevant statistics.

\item{v}{v-statistic}
\item{vlow}{lower level confidence interval of omega}
\item{vhigh}{upper level confidence interval of omega}
\item{n}{sample size}
\item{df}{degrees of freedom}
\item{x2}{significance statistic}
\item{p}{p-value}
\item{estimate}{the V statistic and confidence interval in
APA style for markdown printing}
\item{statistic}{the X2-statistic in APA style for markdown printing}
}
\description{
This function displays V and non-central confidence interval
for the specified chi-square statistic.
}
\details{
V is calculated by finding the square root of chi-squared divided by the product
of the sample size and the degrees of freedom with the lowest value.

v = sqrt(x2 / (n * dfsmall))

\href{https://www.aggieerin.com/shiny-server/tests/chiv.html}{Learn more on our example page.}
}
\examples{

#The following example is derived from the "chisq_data" dataset, included
#in the MOTE library.

#Individuals were polled about their number of friends (low, medium, high)
#and their number of kids (1, 2, 3+) to determine if there was a
#relationship between friend groups and number of children, as we
#might expect that those with more children may have less time for
#friendship maintaining activities.

chisq.test(chisq_data$kids, chisq_data$friends)

v.chi.sq(x2 = 2.0496, n = 60, r = 3, c = 3, a = .05)

#Please note, if you see a warning, that implies the lower effect should
#be zero, as noted.
}
\keyword{chi-square}
\keyword{effect}
\keyword{size,}
