% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_moead.R
\name{print.moead}
\alias{print.moead}
\title{print.moead}
\usage{
\method{print}{moead}(x, ...)
}
\arguments{
\item{x}{list object of class \emph{moead}
(generated by \code{\link[=moead]{moead()}})}

\item{...}{other parameters to be passed down to specific summary functions
(currently unused)}
}
\description{
S3 method for printing \emph{moead} objects (the output of \code{\link[=moead]{moead()}}).
}
\section{References}{

F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr
}

\examples{
problem.1 <- list(name = "example_problem",
                  xmin = rep(-1,30),
                  xmax = rep(1,30),
                  m    = 2)
out <- moead(preset    = preset_moead("original2"),
             problem   = problem.1,
             stopcrit  = list(list(name = "maxiter",
                                   maxiter = 100)),
             showpars  = list(show.iters = "dots",
                              showevery  = 10))
print(out)

}
