% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_neigborhood.R
\name{order_neighborhood}
\alias{order_neighborhood}
\title{Order Neighborhood for MOEA/D}
\usage{
order_neighborhood(bigZ, B, V, Vt, constraint)
}
\arguments{
\item{bigZ}{Matrix of scalarized performance values by neighborhood,
generated by \code{\link[=scalarize_values]{scalarize_values()}}}

\item{B}{Neighborhood matrix, generated by \code{\link[=define_neighborhood]{define_neighborhood()}}.}

\item{V}{List object containing information about the constraint violations
of the \emph{candidate solutions}, generated by \code{\link[=evaluate_population]{evaluate_population()}}}

\item{Vt}{List object containing information about the constraint violations
of the \emph{incumbent solutions}, generated by \code{\link[=evaluate_population]{evaluate_population()}}}

\item{constraint}{list containing the parameters defining the constraint
handling method. See Section \verb{Constraint Handling} of the \code{\link[=moead]{moead()}}
documentation for details.}
}
\value{
\verb{[N x (T+1)]} matrix of preference indexes. Each row contains
the T indexes of the candidate solutions in the neighborhood of
a given subproblem, plus a value (column T+1) for the incumbent solution of
that subproblem, in an order defined by the constraint handling method
specified in \code{moead.env$constraint}.
}
\description{
Calculates the ordering of competing solutions for each subproblem in the
MOEA/D, based on their scalarized performance and violation values.
}
\details{
This routine receives a matrix of scalarized performance values (returned by
\code{\link[=scalarize_values]{scalarize_values()}}), a neighborhood matrix, and the list of violation
values for the candidate and incumbent populations. It calculates the
preference order of the candidates for each neighborhood based on the
performance values and constraint handling method.

The list of available constraint handling methods can be generated using
\code{\link[=get_constraint_methods]{get_constraint_methods()}}.
}
\section{References}{

F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr
}

