% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMLR.R
\name{B_est}
\alias{B_est}
\title{Estimantion of unknown Markov-modulated linear regression model parameters using GLSM}
\usage{
B_est(tGiven, initState, X, Y, lambda, W = TRUE)
}
\arguments{
\item{tGiven}{Vector of the observed times (n x 1), n – number of observations}

\item{initState}{Vector of the initial states (n x 1), n – number of observations}

\item{X}{Matrix of predictors (n x k), n - number of observations, k - number of columns (k - 1 - number of regressors).}

\item{Y}{Vector of the responses Y, n – number of observations}

\item{lambda}{Matrix with the known transition rates \eqn{\lambda_{i,j}}, (m x m), m – number of states}

\item{W}{an optional logical variable indicating should vector of weights be used in the fitting process or not.
If TRUE, matrix with weights is used (that is, inverse values to tGiven – observed times).}
}
\value{
Vector of estimated parameters \eqn{\beta}
}
\description{
This function is used to fit Markov-modulated linear regression models with two states of external environment.
This function estimates Markov-modulated linear regression model parameters, using GLSM.
Function uses the algorithm based on eigenvalues and eigenvectors decompositions.
}
\details{
Function calculates the following expression:
![](vecB.png "Fig.2"),
where vector of average sojourn times in each state $t_{i}$ is calculated using function Aver_soj_time, $t_{i}$ is an element of tGiven, $x_{i}$ is a vector of matrix X.
}
\examples{

lambda <- matrix(c(0, 0.33, 0.45, 0), nrow = 2, ncol = 2, byrow = TRUE)
Xtest <- cbind(rep_len(1,10),c(2,5,7,3,1,1,2,2,3,6), c(5,9,1,2,3,2,3,5,2,2))
tGiven <- matrix (c(6,4.8,1,2.6,6.4,1.7,2.9,4.4,1.5,3.4), nrow = 10, ncol = 1)
Y <- matrix(c (5.7, 9.9, 7.8, 14.5, 8.2, 14.5, 32.2, 3.8, 16.5, 7.7),nrow = 10, ncol = 1)
initState <- matrix (c(2,1,1,2,2,2,1,1,2,1),nrow = 10, ncol = 1)
B_est(tGiven,initState,Xtest,Y,lambda,W = 1)
}
