% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecc.R
\name{ecc}
\alias{ecc}
\title{Fit an Ensemble of Classifier Chains (ECC)}
\usage{
ecc(x, y, m = 5, prop_subset = 0.95, run_parallel = FALSE,
  silent = TRUE, .f = NULL, ...)
}
\arguments{
\item{x}{A data frame or matrix of features.}

\item{y}{A data frame or matrix of labels. Each label must be its own column
and each instance (observation) must be a row of 0s and 1s, indicating which
labels belong to the instance.}

\item{m}{Number of classifier chains (models) to train. Recommended:
\code{m = 3} and \code{m = 7} for 4-core and 8-core systems, respectively.}

\item{prop_subset}{The proportion of the training data to utilize when
\code{m} is greater than 1. Each set of classifier chains in the ensemble
will use a random subset (95\% by default) of the supplied training data.}

\item{run_parallel}{Whether to utilize multicore capabilities of the system.}

\item{silent}{Whether to print progress messages to console. Recommended.}

\item{.f}{User-supplied classifier training function. If not supplied, the
trainer will use the built-in classifier. See Details for more information.}

\item{...}{additional arguments to pass to \code{.f}.}
}
\value{
An object of class \code{ECC} containing: \itemize{
 \item \code{y_labels} : names of the columns of \code{y}
 \item \code{fits} : An list of length \code{m}, each element being a set of
   classifier chains - a list of length \code{L = ncol(y)} where each element
   is a fitted model object trained to predict each of the \code{L} labels.
}
}
\description{
Constructs an ensemble of classifier chains, each chain using a
  user-supplied base classifier.
}
\examples{
x <- movies_train[, -(1:3)]
y <- movies_train[, 1:3]

fit <- ecc(x, y, m = 1, .f = glm.fit, family = binomial(link = "logit"))

\dontrun{

fit <- ecc(x, y, .f = randomForest::randomForest)

fit <- ecc(x, y, m = 7, .f = C50::C5.0, trials = 10)
}
}

