% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_vae_independent.R
\name{build_vae_independent}
\alias{build_vae_independent}
\title{Build a VAE that fits to a standard N(0,I) latent distribution with independent latent traits}
\usage{
build_vae_independent(
  num_items,
  num_skills,
  Q_matrix,
  model_type = 2,
  enc_hid_arch = c(ceiling((num_items + num_skills)/2)),
  hid_enc_activations = rep("sigmoid", length(enc_hid_arch)),
  output_activation = "sigmoid",
  kl_weight = 1,
  learning_rate = 0.001
)
}
\arguments{
\item{num_items}{an integer giving the number of items on the assessment; also the number of nodes in the input/output layers of the VAE}

\item{num_skills}{an integer giving the number of skills being evaluated; also the dimensionality of the distribution learned by the VAE}

\item{Q_matrix}{a binary, \code{num_skills} by \code{num_items} matrix relating the assessment items with skills}

\item{model_type}{either 1 or 2, specifying a 1 parameter (1PL) or 2 parameter (2PL) model; if 1PL, then all decoder weights are fixed to be equal to one}

\item{enc_hid_arch}{a vector detailing the size of hidden layers in the encoder; the number of hidden layers is determined by the length of this vector}

\item{hid_enc_activations}{a vector specifying the activation function in each hidden layer in the encoder; must be the same length as \code{enc_hid_arch}}

\item{output_activation}{a string specifying the activation function in the output of the decoder; the ML2P model always uses 'sigmoid'}

\item{kl_weight}{an optional weight for the KL divergence term in the loss function}

\item{learning_rate}{an optional parameter for the adam optimizer}
}
\value{
returns three keras models: the encoder, decoder, and vae.
}
\description{
Build a VAE that fits to a standard N(0,I) latent distribution with independent latent traits
}
\examples{
\donttest{
Q <- matrix(c(1,0,1,1,0,1,1,0), nrow = 2, ncol = 4)
models <- build_vae_independent(4, 2, Q,
          enc_hid_arch = c(6, 3), hid_enc_activation = c('sigmoid', 'relu'),
          output_activation = 'tanh', kl_weight = 0.1)
models <- build_vae_independent(4, 2, Q)
vae <- models[[3]]
}
}
