% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MJM_predict.R
\name{MJM_predict}
\alias{MJM_predict}
\title{Prediction of MJM model}
\usage{
MJM_predict(
  object,
  newdata,
  type = c("link", "parameter", "probabilities", "cumhaz"),
  dt,
  id,
  FUN = function(x) {
     mean(x, na.rm = TRUE)
 },
  subdivisions = 7,
  cores = NULL,
  chunks = 1,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{bamlss-model object to be predicted.}

\item{newdata}{Dataset for which to create predictions. Not needed for
conditional survival probabilities.}

\item{type}{Character string indicating which type of predictions to compute.
\code{link} returns estimates for all predictors with the respective link
functions applied, \code{"parameter"} returns the estimates for all
pedictors, \code{"probabilities"} returns the survival probabilities
conditional on the survival up to the last longitudinal measurement, and
\code{"cumhaz"} return the cumulative hazard up to the survival time or for
a time window after the last longitudinal measurement. If \code{type} is
set to \code{"loglik"}, the log-likelihood of the joint model is returned.
Note that types \code{"probabilities"} and \code{"cumhaz"} are not yet
implemented.}

\item{dt}{The time window after the last observed measurement for which
predictions should be computed.}

\item{id}{Integer or character, that specifies the individual for which the
plot should be created.}

\item{FUN}{A function that should be applied on the samples of predictors or
parameters, depending on argument \code{type}.}

\item{subdivisions}{Number of Gaussian quadrature points for survival
integral calculation.}

\item{cores}{Specifies the number of cores that should be used for
prediction. Note that this functionality is based on the
\code{\link[parallel]{parallel}} package.}

\item{chunks}{Should computations be split into \code{chunks}? Prediction is
then processed sequentially.}

\item{verbose}{Print information during runtime of the algorithm.}

\item{...}{Currently not used.}
}
\description{
Note: Writing a predict function is a bit tricky.
For longitudinal prediction, if subject specific predictions are wanted, then
the PCRE terms must be attached to newdata and already evaluated.
If the model uses standardized survival matrices, the different linear
predictors should be predicted using different data sets.
}
