% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{compare_sir}
\alias{compare_sir}
\title{Compare SIR results and generate categorical agreement}
\usage{
compare_sir(gold_standard, test)
}
\arguments{
\item{gold_standard}{Susceptibility results in AMR::sir format}

\item{test}{Susceptibility results in AMR::sir format}
}
\value{
factor vector with the following levels: M, vM, m.
}
\description{
Compare two AMR::sir vectors and generate a categorical agreement vector with
the following levels: M (major error), vM (very major error), m (minor error).
The error definitions are:
\enumerate{
\item Major error (M): The test result is resistant (R) when the gold standard
is susceptible (S).
\item vM (very major error): The test result is susceptible (S) when the gold
standard is resistant (R).
\item Minor error (m): The test result is intermediate (I) when the gold standard
is susceptible (S) or resistant (R), or vice versa.
}
}
\examples{
gold_standard <- c("S", "R", "I", "I")
gold_standard <- AMR::as.sir(gold_standard)
test <- c("S", "I", "R", "R")
test <- AMR::as.sir(test)
compare_sir(gold_standard, test)
}
