% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equilibrium-epiSIS.R
\name{make_Q_SEI}
\alias{make_Q_SEI}
\title{Rate Matrix (Q) for Adult Mosquito SEI Dynamics}
\usage{
make_Q_SEI(q, n, mu, c, a, x)
}
\arguments{
\item{q}{related to scale parameter of Gamma distributed EIP (1/q is mean length of EIP)}

\item{n}{shape parameter of Gamma distributed EIP}

\item{mu}{mosquito mortality rate}

\item{c}{human to mosquito transmission efficiency}

\item{a}{human biting rate}

\item{x}{prevalence of disease in humans}
}
\value{
rate matrix for a single (emergence) cohort of SEI mosquito
}
\description{
Construct the infinitesimal generator matrix for (individual) adult female
infection dynamics. Adult females follow SEI (Susceptible-Exposed-Infectious)
style dynamics with a Gamma distributed EIP, with a mean duration 1/q and
variance 1/nq^2 (following shape-scale parameterization, EIP ~ Gamma(n,1/nq)).
This function only constructs the rate matrix for either a single mosquito or
cohort that all emerged at the same time (the rate matrix for a population
with emergence is infinite in dimension).
}
