% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFO_kinetics.R
\name{MFO_kinetics}
\alias{MFO_kinetics}
\title{Maximal Fat Oxidation Kinetics}
\usage{
MFO_kinetics(MFO_data)
}
\arguments{
\item{MFO_data}{a data frame obtained from MFO function}
}
\value{
{Returns a list which contains:
\itemize{
\item MFO_kinetics_data: database used to create the MFO kinetics plot.
\item MFO_kinetics_plot: ggplot object with the MFO kinetics plot.
\item d: dilatation.
\item t: translation.
\item s: symmetry.
}}
}
\description{
Maximal Fat Oxidation Kinetics
}
\examples{
\dontrun{
# Get old working directory
oldwd <- getwd()

# Set temporary directory
setwd(tempdir())

# Read dfs
data(list = c("basal_df", "MFO_df", "VO2max_df"), package = "MFO")

# Convert to data.frame
basal_df <- data.frame(basal_df)
MFO_df <- data.frame(MFO_df)
VO2max_df <- data.frame(VO2max_df)

# Calculate MFO and Fatmax
result_MFO <- MFO(step_time = 20,
                 db_MFO = MFO_df,
                 db_basal = basal_df,
                 db_graded = VO2max_df,
                 cv_var = "RER",
                 author = "Frayn",
                 VO2max = NULL)

# Calculate MFO Kinetics
result_MFO_kinetics <- MFO_kinetics(result_MFO$MFO_db)

# set user working directory
setwd(oldwd)
}

}
