% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFO.R
\name{MFO}
\alias{MFO}
\title{Maximal Fat Oxidation & Fat Max Function}
\usage{
MFO(
  step_time,
  db_MFO,
  db_basal,
  db_graded = NULL,
  cv_var,
  author,
  VO2max = NULL
)
}
\arguments{
\item{step_time}{how often the data was collected (in seconds).}

\item{db_MFO}{database containing MFO test.}

\item{db_basal}{database containing basal test.}

\item{db_graded}{database containing incremental exercise test.}

\item{cv_var}{variable to estimate coefficient of variation. Can be: VO2, VCO2 or RER.}

\item{author}{author to estimate MFO. Can be: Frayn or Jeukendrup.}

\item{VO2max}{VO2max can be passed directly using this argument instead of use db_graded argument.}
}
\value{
{Returns a list which contains:
\itemize{
\item MFO_db: database used to create the MFO plot.
\item MFO_plot: ggplot object with the MFO plot.
\item MFO: Maximal fat oxidation.
\item FAT_MAX: Intensity that elicits MFO.
\item x_CHO: carbohydrates in basal metabolism.
\item x_FAT: fat in basal metabolism.
\item x_Kcal: Kcal in basal metabolism.
}}
}
\description{
Maximal Fat Oxidation & Fat Max Function
}
\examples{

\dontrun{
# Get old working directory
oldwd <- getwd()

# Set temporary directory
setwd(tempdir())

# Read dfs
data(list = c("basal_df", "MFO_df", "VO2max_df"), package = "MFO")

# Convert to data.frame
basal_df <- data.frame(basal_df)
MFO_df <- data.frame(MFO_df)
VO2max_df <- data.frame(VO2max_df)

# Calculate MFO and Fatmax
result_MFO <- MFO(step_time = 20,
                 db_MFO = MFO_df,
                 db_basal = basal_df,
                 db_graded = VO2max_df,
                 cv_var = "RER",
                 author = "Frayn",
                 VO2max = NULL)

# set user working directory
setwd(oldwd)
}

}
