% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmaD_MEFM.R
\name{sigmaD_MEFM}
\alias{sigmaD_MEFM}
\title{HAC covariance estimator for asymptotic normality on each row j of loading matrix estimator}
\usage{
sigmaD_MEFM(k, D, Q, C, E, j, beta = 0)
}
\arguments{
\item{k}{Integer to choose the mode of loading matrix, either 1 or 2.}

\item{D}{Eigenvalue matrix of sample covariance matrix, with dimension rk by rk.}

\item{Q}{Estimated row (k=1) or column (k=2) loading matrix, with dimension p (for k=1) or q (for k=2) by rk.}

\item{C}{Estimated common component series, written in an array with dimension (T,p,q) where the first dimension denotes time.}

\item{E}{Estimated error matrix time series, written in an array with the same dimension as C.}

\item{j}{Integer representing the row of loading matrix. Value should be integers from minimum 1 to maximum p (for k=1) or q (for k=2).}

\item{beta}{Lag parameter of the HAC type. Default is 0.}
}
\value{
A matrix of dimension rk by rk
}
\description{
Computing the HAC covariance estimator for asymptotic normality on each row j of the row or column loading matrix estimator
}
\examples{
TT = 40;
d = c(40,40);
r = c(2,2);
re = c(2,2);
eta = list(c(0,0), c(0,0));
coef_f = c(0.7, 0.3, -0.4, 0.2, -0.1);
coef_fe = c(-0.7, -0.3, -0.4, 0.2, 0.1);
coef_e = c(0.8, 0.4, -0.4, 0.2, -0.1);
param_mu = c(0,1);
param_alpha = c(0,1);
param_beta = c(0,1);
data_example = gen_MEFM(TT,d,r,re,eta, coef_f, coef_fe, coef_e, param_mu, param_alpha, param_beta);
est_result = est_MEFM(data_example$MEFM, r=r);
D2 <- diag(x=(svd(est_result$covMatrix[[2]])$d)[1:r[2]], nrow=r[2], ncol=r[2]);
sigmaD_MEFM(2, D2, est_result$A[[2]], est_result$Ct, data_example$MEFM - est_result$Yt, 1, 0);


}
