% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{get_MEDseq_results}
\alias{get_MEDseq_results}
\title{Extract results from a MEDseq model}
\usage{
get_MEDseq_results(x,
                   what = c("z", "MAP", "DBS", "ASW"), 
                   rank = 1L, 
                   criterion = c("bic", "icl", "aic", "dbs", 
                                 "asw", "cv", "nec", "loglik"), 
                   G = NULL, 
                   modtype = NULL, 
                   noise = TRUE, 
                   ...)
}
\arguments{
\item{x}{An object of class \code{"MEDseq"} generated by \code{\link{MEDseq_fit}} or an object of class \code{"MEDseqCompare"} generated by \code{\link{MEDseq_compare}}.}

\item{what}{A character string indicating the desired results to extract.}

\item{rank}{A number indicating what \code{rank} model results should be extracted from, where the \code{rank} is determined by \code{criterion}. Defaults to \code{1}, i.e. the best model.}

\item{criterion}{The \code{criterion} used to determine the ranking. Defaults to \code{"bic"}.}

\item{G}{Optional argument giving the number of components in the model for which results are desired. Can be supplied with or without also specifying \code{modtype}.}

\item{modtype}{Optional argument giving the desired model type for which results are desired. Can be supplied with or without also specifying \code{G}.}

\item{noise}{A logical indicating whether models with a noise component should be considered. Defaults to \code{TRUE}.}

\item{...}{Catches unused arguments.}
}
\value{
The desired results extracted from the \code{MEDseq} model.
}
\description{
Utility function for extracting results of submodels from \code{"MEDseq"} objects when a range of models were run via \code{\link{MEDseq_fit}}.
}
\details{
The arguments \code{rank} and \code{criterion} are invoked when one or more of the arguments \code{G} and \code{modtype} are missing. Thus, supplying \code{G} and \code{modtype} allows \code{rank} and \code{criterion} to be bypassed entirely.
}
\note{
Arguments to this function can be supplied to \code{\link{plot.MEDseq}} via the \code{...} construct.
}
\examples{
\donttest{data(biofam)
# mod <- MEDseq_fit(seqdef(biofam[10:25] + 1L), G=9:10)

# Extract the MAP clustering of the best 9-cluster model according to the asw criterion
# get_MEDseq_results(mod, what="MAP", G=9, criterion="asw")

# Extract the DBS values of the best UUN model according to the dbs criterion
# get_MEDseq_results(mod, what="DBS", modtype="UUN", criterion="dbs")

# Plot the DBS values of this same model, by passing get_MEDseq_results arguments through plot
# plot(mod, type="dbsvals", modtype="UUN", criterion="dbs")}
}
\seealso{
\code{\link{MEDseq_fit}}, \code{\link{plot.MEDseq}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@mu.ie}>
}
\keyword{utility}
