% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.fcRegression.R
\name{predict.fcRegression}
\alias{predict.fcRegression}
\title{Predicted values based on fcRegression object}
\usage{
\method{predict}{fcRegression}(object, newData.FC, newData.Z = NULL, ...)
}
\arguments{
\item{object}{A fcRegression class object produced by \code{\link{fcRegression}}.}

\item{newData.FC}{A atomic vector or a matrix or a dataframe or
a functional_variable class object or a list of objects above.
See argument FC in \code{\link{fcRegression}}.}

\item{newData.Z}{A dataframe or a matrix or a atomic vector.
See arguement Z in \code{\link{fcRegression}}.}

\item{...}{Further arguments passed to or from other methods,
including \code{\link[stats]{predict.lm}}, \code{\link[stats]{predict.glm}},
\code{\link[lme4]{predict.merMod}}.}
}
\value{
See \code{\link[stats]{predict.lm}}, \code{\link[stats]{predict.glm}},
\code{\link[lme4]{predict.merMod}}.
}
\description{
Predicted values based on the linear model with functional covariates represented by a "fcRegression" class object.
}
\details{
If no new data is input, will return the fitted value.
}
\examples{
data(MECfda.data.sim.0.0)
res = fcRegression(FC = MECfda.data.sim.0.0$FC, Y=MECfda.data.sim.0.0$Y, Z=MECfda.data.sim.0.0$Z,
                   basis.order = 5, basis.type = c('Bspline'),
                   formula.Z = ~ Z_1 + (1|Z_2))
data(MECfda.data.sim.1.0)
predict(object = res, newData.FC = MECfda.data.sim.1.0$FC,newData.Z = MECfda.data.sim.1.0$Z)
}
\author{
Heyang Ji
}
