% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classDefintions.R
\docType{class}
\name{numericBasis_series-class}
\alias{numericBasis_series-class}
\alias{numericBasis_series}
\title{Linear combination of a sequence of basis functions represented numerically}
\description{
A linear combination of basis function \eqn{\{\rho_k\}_{k=1}^p},
\deqn{\sum_{k=1}^p c_k \rho_k(t).}
}
\section{Slots}{

\describe{
\item{\code{coef}}{linear coefficient \eqn{\{c_k\}_{k=1}^p}.}

\item{\code{numeric_basis}}{\eqn{\{\rho_k\}_{k=1}^p} represented by a \code{numeric_basis} object.
See \code{\link{numeric_basis}}.}
}}

\examples{
t_0 = 0
period = 1
t_points = seq(0.05,0.95,length.out = 19)
nb = numeric_basis(
  basis_function = cbind(1,cos(t_points),sin(t_points)),
  t_points       = t_points,
  t_0            = t_0,
  period         = period
)
ns = numericBasis_series(coef = c(0.8,1.2,1.6),numeric_basis = nb)
}
\author{
Heyang Ji
}
