% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtp.R
\name{wtp}
\alias{wtp}
\title{Probe willingness to pay}
\usage{
wtp(x, threshold = NULL, probability = NULL)
}
\arguments{
\item{x}{object of class \code{CEAC}}

\item{threshold}{cost-effectiveness threshold}

\item{probability}{probability of being cost-effective}
}
\value{
\code{wtp} either the probability or the threshold. If there is no exact match
to the given parameter in the bootstrap samples, the result is interpolated.
}
\description{
Get the probability of being cost-effective given a certain
cost-effectiveness threshold, and vice versa.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
One of the two parameters \code{threshold} and \code{probability}
should be specified.
}
\examples{
CEA(gnomes, insulationMethod, Costs, diffHATS, 1000, "acorns") |>
  CEAC() |>
  wtp(probability = 0.80)
CEA(gnomes, insulationMethod, Costs, diffHATS, 1000, "acorns") |>
  CEAC() |>
  wtp(threshold = 8)
}
\author{
Mathijs Deen
}
