% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateFixed.R
\name{estimateFixed}
\alias{estimateFixed}
\title{Fixed Age for MCMCtree analysis input}
\usage{
estimateFixed(minAge, phy, monoGroups, writeMCMCtree = FALSE,
  MCMCtreeName = "estimateFixed.tre")
}
\arguments{
\item{minAge}{vector of fixed age bounds for nodes matching order in monoGroups}

\item{phy}{fully resolved phylogeny in ape format}

\item{monoGroups}{list  with each element containing species that define a node of interest}

\item{writeMCMCtree}{logical whether to write tree in format that is compatible with MCMCTree to file}

\item{MCMCtreeName}{MCMCtree.output file name}
}
\value{
list containing node estimates for each distribution
\itemize{
 \item{"parameters"}{ estimated parameters for each node}
 \item{"apePhy"}{ phylogeny in ape format with node labels showing node distributions}
 \item{"MCMCtree"}{ phylogeny in MCMCtreeR format}
 \item{"nodeLabels"}{ node labels in MCMCtreeR format}
}

If writeMCMCtree=TRUE tree in MCMCtree format in file "MCMCtreeName" written to current working directory
}
\description{
Produce fixed age trees for MCMCtree analysis
}
\examples{
data(apeData)
attach(apeData)
## extract taxon descending from calibrated nodes 8, 10, 11, 13
## these nodes can be visualised using plot.phylo
## and nodelabels from ape
monophyleticGroups <- tipDes(apeData$apeTree, c(8,10,11,13))
minimumTimes <- c("nodeOne"=15, "nodeTwo"=6,
"nodeThree"=8, "nodeFour"=13) / 10
maximumTimes <- c("nodeOne" = 30, "nodeTwo" = 12,
"nodeThree"=12, "nodeFour" = 20) / 10
estimateFixed(minAge=minimumTimes[1],
monoGroups=monophyleticGroups[[1]], phy=apeTree)$MCMCtree
}
\author{
Mark Puttick
}
