% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_mixed.R
\name{gen_mixed}
\alias{gen_mixed}
\title{Continuous and Ordinal Simulated Data}
\usage{
gen_mixed(n, R, indc, thresholds)
}
\arguments{
\item{n}{the sample size.}

\item{R}{the correlation coefficient matrix.}

\item{indc}{vector to indicate whether variables are continuous or categorical.}

\item{thresholds}{list contains thresholds for ordinal variables}
}
\value{
\item{latent}{the original normal data.}

\item{observed}{the observed ordinal data.}
}
\description{
Generate multi-normal sample and segment it into ordinal.
}
\examples{
library(mvtnorm)
set.seed(1997)
R1 = gen_CCM(6)
n = 1000
indc = 4:6
thresholds = list(
  c(),
  c(),
  c(),
  c(0),
  c(-0.5,0),
  c(0,0.5)
)
data1 = gen_mixed(n,R1,indc,thresholds)$observed
data1 = data.frame(data1)
table(data1$X4,data1$X5)
table(data1$X5,data1$X6)
}
