% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_correlation_matrix.R
\name{draw_correlation_matrix}
\alias{draw_correlation_matrix}
\title{Draw the Correlation Matrix}
\usage{
draw_correlation_matrix(
  data1,
  order_indx,
  pair_est = FALSE,
  MLE = FALSE,
  R0 = NULL,
  app = TRUE,
  korder = 2,
  max_iter = 1000,
  max_tol = 1e-08,
  show_log = FALSE
)
}
\arguments{
\item{data1}{a dataframe containing continuous or ordinal variable.}

\item{order_indx}{a vector to indicate the ordinal variables.}

\item{pair_est}{bool value, TRUE for pairwise estimation, FALSE for simultaneous estimation.}

\item{MLE}{bool value, TRUE for maximum likelihood estimation, FALSE for IRLS (pairwise) or IGMM (simultaneous) estimation.}

\item{R0}{the initial value for correlation vector, default Pearson correlation matrix.}

\item{app}{bool value for approximation, TRUE for Legendre approximation, FALSE for common integral.}

\item{korder}{the order of Legendre approximation.}

\item{max_iter}{max iteration number for IGMM.}

\item{max_tol}{max tolerance for iteration algorithm.}

\item{show_log}{bool value, TRUE for showing calculation log.}
}
\value{
the SPLOM plot.
}
\description{
Estimate the MCCM from dataframe and draw it with scatter plot of matrices (SPLOM). With bivariate scatter plots below the diagonal, histograms on the diagonal, and the polychoric correlation coefficients with standard errors above the diagonal. Correlation ellipses are drawn in the same graph. The red lines below the diagonal are the LOESS smoothed lines, fitting a smooth curve between two variables.
}
\examples{

library(mvtnorm)
library(MASS)
library(polycor)
library(lavaan)
set.seed(1997)
n = 10000
rho12=0.3
rho13=0.4
rho14=0.5
rho23=0.6
rho24=0.7
rho34=0.8

R = matrix(c(1,rho12,rho13,rho14,rho12,1,rho23,rho24,rho13,rho23,1,rho34,
rho14,rho24,rho34,1),4,4)
indc = c(3,4)
thresholds = list(c(),c(),0,0)
data1 = gen_mixed(n=n,R=R,indc=indc,thresholds=thresholds)
data2 = data.frame(data1$observed)

# pairwise MLE estimation
draw_correlation_matrix(data2,indc,TRUE,TRUE)
# pairwise IRLS estimation
draw_correlation_matrix(data2,indc,TRUE,FALSE)
# simultaneous MLE estimation
draw_correlation_matrix(data2,indc,FALSE,TRUE)
# simultaneous IGMM estimation
draw_correlation_matrix(data2,indc,FALSE,FALSE)
}
\seealso{
\link{MCCM_est},
\link{summary_MCCM_est}
}
