% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.jags.R
\name{write.timecourse}
\alias{write.timecourse}
\title{Adds sections of JAGS code for an MBNMA model that correspond to alpha
parameters}
\usage{
write.timecourse(model, fun, intercept, positive.scale)
}
\arguments{
\item{model}{A character string representing the MBNMA model in JAGS code}

\item{fun}{An object of class \code{"timefun"} generated (see Details) using any of
\code{tloglin()}, \code{tpoly()}, \code{titp()}, \code{temax()}, \code{tfpoly()}, \code{tspline()} or \code{tuser()}}

\item{intercept}{A boolean object that indicates whether an intercept (written
as \code{alpha} in the model) is to be included. If left as \code{NULL} (the default), an intercept will
be included only for studies reporting absolute means, and will be excluded for
studies reporting change from baseline (as indicated in \code{network$cfb}).}

\item{positive.scale}{A boolean object that indicates whether all continuous
mean responses (y) are positive and therefore whether the baseline response
should be given a prior that constrains it to be positive (e.g. for scales that cannot be <0).}

\item{timecourse}{A character object that contains JAGS code for the
time-course component of the model}
}
\value{
A list of named elements: \code{model} is a character vector of JAGS MBNMA
model code that includes alpha parameter components of the model
\code{timecourse} is a character object that contains JAGS code for the
time-course component of the model, for which alpha will be indexed
correctly
}
\description{
Adds sections of JAGS code for an MBNMA model that correspond to alpha
parameters
}
